<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
if(isset($_POST['category-name'])){
    $v  =   Pf::validator();
    $_POST=$v->sanitize($_POST);
    $cat_name   =   isset($_POST['category-name'])?$_POST['category-name']:'';
    $description    =   !empty($_POST['description'])?$_POST['description']:'';
    $cat_status =   !empty($_POST['status'])?1:2;
    $v->validation_rules(array( 'category-name'=> 'required|max_len,255|min_len,6'));
    $v->filter_rules(array('category-name'=>'trim|sanitize_string', 'description'=>'trim|sanitize_string'));
    $validate   =  $v->run($_POST);
    if($validate === false) {
        $error  = $v->get_readable_errors(false);
    }
    else{
        
        if(!empty($edit_id)){
            $portfolio->db->update('pf_portfolio_categories', array(
                'category_name' => $cat_name,
                'category_status' => $cat_status,
                'category_description' => $description
                    ), "`category_id`='$edit_id'");
            $note= __('Category is updated successfully','portfolio');
        }else
        {   
            $portfolio->db->insert('pf_portfolio_categories',array(
                'category_name' =>  $cat_name,
                'category_status'=> $cat_status,
                'category_description'=> $description
            ));
            $max    =   $portfolio->db->insert_id();
            $_SESSION['success']    =   'success';
            header('location: ?admin-page=portfolio&sub_page=category&action=edit&id='.$max);
        }
        
    }
     
}
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Portfolio Category','portfolio'); ?></h3>
    </div>
    <div class="panel-body">
                <div class="row pad">
                   
                    <div class="col-md-12">
                        <?php if (!empty($note)) { ?>
                            <script>notif('<?php echo $note; ?>');</script>
                        <?php } ?>
                        <form class="form-horizontal" role="form" method="post" id="form-port"> 
                            <table class="table table-bordered table-configuration">
                                <colgroup><col class="col-md-2">
                                </colgroup>
                                <tbody>
                                    <tr>
                                        <th><label for="" class="control-label"><?php echo __('Category name','portfolio'); ?><span class='requiredfield'>*</span></label></th>
                                        <td id="pname"><?php echo form_input($form_name);  ?><font class="help-block" id="err-name" style="display:none"><?php echo __('The field is required','portfolio'); ?></font></td>
                                    </tr>
                                    <tr>
                                        <th><label for="" class="control-label"><?php echo __('Category description','portfolio'); ?></label></th>
                                        <td><textarea name="description" id="description" class="form-control" cols="40" rows="5" ><?php echo $description; ?></textarea></td>
                                    </tr>
                                    <tr>
                                        <th><label for="" class="control-label"><?php echo __('Publish','portfolio'); ?></label></th>
                                        <td><?php echo form_checkbox($form_stat); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </form>                                 
                            <?php 
                              add_toolbar_button(form_button("<i class='fa fa-check'></i> ". __('Save', 'portfolio') ,array('onclick'=>'save_changes();','class' => 'btn btn-primary')));
                              add_toolbar_button(form_button(" ". __('Cancel', 'portfolio') ,array('onclick'=>"window.location='".admin_url($ref,false)."'",'class' => 'btn btn-default')));
                            ?>
                    </div>
                </div>

            </div>
</div>